@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.azurenative.devices.kotlin.outputs.IotDpsPropertiesDescriptionResponse
import com.pulumi.azurenative.devices.kotlin.outputs.IotDpsSkuInfoResponse
import com.pulumi.azurenative.devices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devices.kotlin.outputs.IotDpsPropertiesDescriptionResponse.Companion.toKotlin as iotDpsPropertiesDescriptionResponseToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.IotDpsSkuInfoResponse.Companion.toKotlin as iotDpsSkuInfoResponseToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [IotDpsResource].
 */
@PulumiTagMarker
public class IotDpsResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IotDpsResourceArgs = IotDpsResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IotDpsResourceArgsBuilder.() -> Unit) {
        val builder = IotDpsResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IotDpsResource {
        val builtJavaResource = com.pulumi.azurenative.devices.IotDpsResource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IotDpsResource(builtJavaResource)
    }
}

/**
 * The description of the provisioning service.
 * Azure REST API version: 2022-12-12. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2020-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### DPSCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotDpsResource = new AzureNative.Devices.IotDpsResource("iotDpsResource", new()
 *     {
 *         Location = "East US",
 *         Properties = new AzureNative.Devices.Inputs.IotDpsPropertiesDescriptionArgs
 *         {
 *             EnableDataResidency = false,
 *         },
 *         ProvisioningServiceName = "myFirstProvisioningService",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Devices.Inputs.IotDpsSkuInfoArgs
 *         {
 *             Capacity = 1,
 *             Name = AzureNative.Devices.IotDpsSku.S1,
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devices.NewIotDpsResource(ctx, "iotDpsResource", &devices.IotDpsResourceArgs{
 * 			Location: pulumi.String("East US"),
 * 			Properties: &devices.IotDpsPropertiesDescriptionArgs{
 * 				EnableDataResidency: pulumi.Bool(false),
 * 			},
 * 			ProvisioningServiceName: pulumi.String("myFirstProvisioningService"),
 * 			ResourceGroupName:       pulumi.String("myResourceGroup"),
 * 			Sku: &devices.IotDpsSkuInfoArgs{
 * 				Capacity: pulumi.Float64(1),
 * 				Name:     pulumi.String(devices.IotDpsSkuS1),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devices.IotDpsResource;
 * import com.pulumi.azurenative.devices.IotDpsResourceArgs;
 * import com.pulumi.azurenative.devices.inputs.IotDpsPropertiesDescriptionArgs;
 * import com.pulumi.azurenative.devices.inputs.IotDpsSkuInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotDpsResource = new IotDpsResource("iotDpsResource", IotDpsResourceArgs.builder()
 *             .location("East US")
 *             .properties(IotDpsPropertiesDescriptionArgs.builder()
 *                 .enableDataResidency(false)
 *                 .build())
 *             .provisioningServiceName("myFirstProvisioningService")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(IotDpsSkuInfoArgs.builder()
 *                 .capacity(1)
 *                 .name("S1")
 *                 .build())
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devices:IotDpsResource myFirstProvisioningService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}
 * ```
 */
public class IotDpsResource internal constructor(
    override val javaResource: com.pulumi.azurenative.devices.IotDpsResource,
) : KotlinCustomResource(javaResource, IotDpsResourceMapper) {
    /**
     * The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Service specific properties for a provisioning service
     */
    public val properties: Output<IotDpsPropertiesDescriptionResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                iotDpsPropertiesDescriptionResponseToKotlin(args0)
            })
        })

    /**
     * The resource group of the resource.
     */
    public val resourcegroup: Output<String>?
        get() = javaResource.resourcegroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sku info for a provisioning Service.
     */
    public val sku: Output<IotDpsSkuInfoResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                iotDpsSkuInfoResponseToKotlin(args0)
            })
        })

    /**
     * The subscription id of the resource.
     */
    public val subscriptionid: Output<String>?
        get() = javaResource.subscriptionid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IotDpsResourceMapper : ResourceMapper<IotDpsResource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devices.IotDpsResource::class == javaResource::class

    override fun map(javaResource: Resource): IotDpsResource = IotDpsResource(
        javaResource as
            com.pulumi.azurenative.devices.IotDpsResource,
    )
}

/**
 * @see [IotDpsResource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IotDpsResource].
 */
public suspend fun iotDpsResource(
    name: String,
    block: suspend IotDpsResourceResourceBuilder.() -> Unit,
): IotDpsResource {
    val builder = IotDpsResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IotDpsResource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iotDpsResource(name: String): IotDpsResource {
    val builder = IotDpsResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
