@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The source that the routing rule is to be applied to, such as DeviceMessages.
 */
public enum class RoutingSource(
    public val javaValue: com.pulumi.azurenative.devices.enums.RoutingSource,
) : ConvertibleToJava<com.pulumi.azurenative.devices.enums.RoutingSource> {
    Invalid(com.pulumi.azurenative.devices.enums.RoutingSource.Invalid),
    DeviceMessages(com.pulumi.azurenative.devices.enums.RoutingSource.DeviceMessages),
    TwinChangeEvents(com.pulumi.azurenative.devices.enums.RoutingSource.TwinChangeEvents),
    DeviceLifecycleEvents(com.pulumi.azurenative.devices.enums.RoutingSource.DeviceLifecycleEvents),
    DeviceJobLifecycleEvents(com.pulumi.azurenative.devices.enums.RoutingSource.DeviceJobLifecycleEvents),
    DigitalTwinChangeEvents(com.pulumi.azurenative.devices.enums.RoutingSource.DigitalTwinChangeEvents),
    DeviceConnectionStateEvents(com.pulumi.azurenative.devices.enums.RoutingSource.DeviceConnectionStateEvents),
    MqttBrokerMessages(com.pulumi.azurenative.devices.enums.RoutingSource.MqttBrokerMessages),
    ;

    override fun toJava(): com.pulumi.azurenative.devices.enums.RoutingSource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.enums.RoutingSource): RoutingSource = RoutingSource.values().first { it.javaValue == javaType }
    }
}
