@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.EnrichmentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of an enrichment that your IoT hub applies to messages delivered to endpoints.
 * @property endpointNames The list of endpoints for which the enrichment is applied to the message.
 * @property key The key or name for the enrichment property.
 * @property value The value for the enrichment property.
 */
public data class EnrichmentPropertiesArgs(
    public val endpointNames: Output<List<String>>,
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.EnrichmentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.EnrichmentPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.EnrichmentPropertiesArgs.builder()
            .endpointNames(endpointNames.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnrichmentPropertiesArgs].
 */
@PulumiTagMarker
public class EnrichmentPropertiesArgsBuilder internal constructor() {
    private var endpointNames: Output<List<String>>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The list of endpoints for which the enrichment is applied to the message.
     */
    @JvmName("rhokswagylimvqdy")
    public suspend fun endpointNames(`value`: Output<List<String>>) {
        this.endpointNames = value
    }

    @JvmName("qyrtdjywgcaradoh")
    public suspend fun endpointNames(vararg values: Output<String>) {
        this.endpointNames = Output.all(values.asList())
    }

    /**
     * @param values The list of endpoints for which the enrichment is applied to the message.
     */
    @JvmName("hgplviasxvtcgbmt")
    public suspend fun endpointNames(values: List<Output<String>>) {
        this.endpointNames = Output.all(values)
    }

    /**
     * @param value The key or name for the enrichment property.
     */
    @JvmName("bplwshdeeirfrelt")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value for the enrichment property.
     */
    @JvmName("sgnxiybrkkkfcbmq")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The list of endpoints for which the enrichment is applied to the message.
     */
    @JvmName("nkmbfkwtiqgkinhw")
    public suspend fun endpointNames(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointNames = mapped
    }

    /**
     * @param values The list of endpoints for which the enrichment is applied to the message.
     */
    @JvmName("yrtxgkmscuvtyyht")
    public suspend fun endpointNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointNames = mapped
    }

    /**
     * @param value The key or name for the enrichment property.
     */
    @JvmName("gohwrderavxujref")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value for the enrichment property.
     */
    @JvmName("mckthtlptgodvyso")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EnrichmentPropertiesArgs = EnrichmentPropertiesArgs(
        endpointNames = endpointNames ?: throw PulumiNullFieldException("endpointNames"),
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
