@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.GetDpsCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateName Name of the certificate to retrieve.
 * @property provisioningServiceName Name of the provisioning service the certificate is associated with.
 * @property resourceGroupName Resource group identifier.
 */
public data class GetDpsCertificatePlainArgs(
    public val certificateName: String,
    public val provisioningServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.GetDpsCertificatePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.GetDpsCertificatePlainArgs =
        com.pulumi.azurenative.devices.inputs.GetDpsCertificatePlainArgs.builder()
            .certificateName(certificateName.let({ args0 -> args0 }))
            .provisioningServiceName(provisioningServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDpsCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetDpsCertificatePlainArgsBuilder internal constructor() {
    private var certificateName: String? = null

    private var provisioningServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the certificate to retrieve.
     */
    @JvmName("mxmfeyxynlkmbudo")
    public suspend fun certificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.certificateName = mapped
    }

    /**
     * @param value Name of the provisioning service the certificate is associated with.
     */
    @JvmName("eemggcqpvjyuqwod")
    public suspend fun provisioningServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.provisioningServiceName = mapped
    }

    /**
     * @param value Resource group identifier.
     */
    @JvmName("lldgjgwevhjndveg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDpsCertificatePlainArgs = GetDpsCertificatePlainArgs(
        certificateName = certificateName ?: throw PulumiNullFieldException("certificateName"),
        provisioningServiceName = provisioningServiceName ?: throw
            PulumiNullFieldException("provisioningServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
