@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.GetIotDpsResourcePrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateEndpointConnectionName The name of the private endpoint connection
 * @property resourceGroupName The name of the resource group that contains the provisioning service.
 * @property resourceName The name of the provisioning service.
 */
public data class GetIotDpsResourcePrivateEndpointConnectionPlainArgs(
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.devices.inputs.GetIotDpsResourcePrivateEndpointConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.GetIotDpsResourcePrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.devices.inputs.GetIotDpsResourcePrivateEndpointConnectionPlainArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIotDpsResourcePrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetIotDpsResourcePrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the private endpoint connection
     */
    @JvmName("wriavkhfjhntnfkj")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group that contains the provisioning service.
     */
    @JvmName("gvrxehaderhtsrfg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the provisioning service.
     */
    @JvmName("ckaxiyqhefogyxnb")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetIotDpsResourcePrivateEndpointConnectionPlainArgs =
        GetIotDpsResourcePrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
