@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.ListIotDpsResourceKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property provisioningServiceName The provisioning service name to get the shared access keys for.
 * @property resourceGroupName resource group name
 */
public data class ListIotDpsResourceKeysPlainArgs(
    public val provisioningServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.ListIotDpsResourceKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.ListIotDpsResourceKeysPlainArgs =
        com.pulumi.azurenative.devices.inputs.ListIotDpsResourceKeysPlainArgs.builder()
            .provisioningServiceName(provisioningServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListIotDpsResourceKeysPlainArgs].
 */
@PulumiTagMarker
public class ListIotDpsResourceKeysPlainArgsBuilder internal constructor() {
    private var provisioningServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The provisioning service name to get the shared access keys for.
     */
    @JvmName("nvkifydtxqnbvhko")
    public suspend fun provisioningServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.provisioningServiceName = mapped
    }

    /**
     * @param value resource group name
     */
    @JvmName("jwubxswnhuldexqu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListIotDpsResourceKeysPlainArgs = ListIotDpsResourceKeysPlainArgs(
        provisioningServiceName = provisioningServiceName ?: throw
            PulumiNullFieldException("provisioningServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
