@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.NetworkRuleSetPropertiesArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.DefaultAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network Rule Set Properties of IotHub
 * @property applyToBuiltInEventHubEndpoint If True, then Network Rule Set is also applied to BuiltIn EventHub EndPoint of IotHub
 * @property defaultAction Default Action for Network Rule Set
 * @property ipRules List of IP Rules
 */
public data class NetworkRuleSetPropertiesArgs(
    public val applyToBuiltInEventHubEndpoint: Output<Boolean>,
    public val defaultAction: Output<Either<String, DefaultAction>>? = null,
    public val ipRules: Output<List<NetworkRuleSetIpRuleArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.NetworkRuleSetPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.NetworkRuleSetPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.NetworkRuleSetPropertiesArgs.builder()
            .applyToBuiltInEventHubEndpoint(applyToBuiltInEventHubEndpoint.applyValue({ args0 -> args0 }))
            .defaultAction(
                defaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipRules(
                ipRules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkRuleSetPropertiesArgs].
 */
@PulumiTagMarker
public class NetworkRuleSetPropertiesArgsBuilder internal constructor() {
    private var applyToBuiltInEventHubEndpoint: Output<Boolean>? = null

    private var defaultAction: Output<Either<String, DefaultAction>>? = null

    private var ipRules: Output<List<NetworkRuleSetIpRuleArgs>>? = null

    /**
     * @param value If True, then Network Rule Set is also applied to BuiltIn EventHub EndPoint of IotHub
     */
    @JvmName("ohpywlrxyyadyven")
    public suspend fun applyToBuiltInEventHubEndpoint(`value`: Output<Boolean>) {
        this.applyToBuiltInEventHubEndpoint = value
    }

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("mpxsnjpxakavxxoy")
    public suspend fun defaultAction(`value`: Output<Either<String, DefaultAction>>) {
        this.defaultAction = value
    }

    /**
     * @param value List of IP Rules
     */
    @JvmName("ldxoetufxuaijnkh")
    public suspend fun ipRules(`value`: Output<List<NetworkRuleSetIpRuleArgs>>) {
        this.ipRules = value
    }

    @JvmName("fscauxsnmxstnlxl")
    public suspend fun ipRules(vararg values: Output<NetworkRuleSetIpRuleArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values List of IP Rules
     */
    @JvmName("jmniwgfiphmkjhnk")
    public suspend fun ipRules(values: List<Output<NetworkRuleSetIpRuleArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value If True, then Network Rule Set is also applied to BuiltIn EventHub EndPoint of IotHub
     */
    @JvmName("ynhukdrrhfofhtts")
    public suspend fun applyToBuiltInEventHubEndpoint(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applyToBuiltInEventHubEndpoint = mapped
    }

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("mkampcikqvpslbny")
    public suspend fun defaultAction(`value`: Either<String, DefaultAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("bpvmafjbtnjbgfqs")
    public fun defaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("ntvllmbsixrmbxwn")
    public fun defaultAction(`value`: DefaultAction) {
        val toBeMapped = Either.ofRight<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value List of IP Rules
     */
    @JvmName("fwgxsplvopbokjjc")
    public suspend fun ipRules(`value`: List<NetworkRuleSetIpRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument List of IP Rules
     */
    @JvmName("fxdeeyvmvytmlfse")
    public suspend fun ipRules(argument: List<suspend NetworkRuleSetIpRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkRuleSetIpRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument List of IP Rules
     */
    @JvmName("uqnirbclvgkojxjn")
    public suspend fun ipRules(vararg argument: suspend NetworkRuleSetIpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkRuleSetIpRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument List of IP Rules
     */
    @JvmName("rcvaiixvminxptqo")
    public suspend fun ipRules(argument: suspend NetworkRuleSetIpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkRuleSetIpRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values List of IP Rules
     */
    @JvmName("stetuvrfyifioupt")
    public suspend fun ipRules(vararg values: NetworkRuleSetIpRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    internal fun build(): NetworkRuleSetPropertiesArgs = NetworkRuleSetPropertiesArgs(
        applyToBuiltInEventHubEndpoint = applyToBuiltInEventHubEndpoint ?: throw
            PulumiNullFieldException("applyToBuiltInEventHubEndpoint"),
        defaultAction = defaultAction,
        ipRules = ipRules ?: throw PulumiNullFieldException("ipRules"),
    )
}
