@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.RoutingEndpointsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
 * @property cosmosDBSqlCollections The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
 * @property eventHubs The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
 * @property serviceBusQueues The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
 * @property serviceBusTopics The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
 * @property storageContainers The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
 */
public data class RoutingEndpointsArgs(
    public val cosmosDBSqlCollections: Output<List<RoutingCosmosDBSqlApiPropertiesArgs>>? = null,
    public val eventHubs: Output<List<RoutingEventHubPropertiesArgs>>? = null,
    public val serviceBusQueues: Output<List<RoutingServiceBusQueueEndpointPropertiesArgs>>? = null,
    public val serviceBusTopics: Output<List<RoutingServiceBusTopicEndpointPropertiesArgs>>? = null,
    public val storageContainers: Output<List<RoutingStorageContainerPropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.RoutingEndpointsArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.RoutingEndpointsArgs =
        com.pulumi.azurenative.devices.inputs.RoutingEndpointsArgs.builder()
            .cosmosDBSqlCollections(
                cosmosDBSqlCollections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .eventHubs(
                eventHubs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceBusQueues(
                serviceBusQueues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceBusTopics(
                serviceBusTopics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageContainers(
                storageContainers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RoutingEndpointsArgs].
 */
@PulumiTagMarker
public class RoutingEndpointsArgsBuilder internal constructor() {
    private var cosmosDBSqlCollections: Output<List<RoutingCosmosDBSqlApiPropertiesArgs>>? = null

    private var eventHubs: Output<List<RoutingEventHubPropertiesArgs>>? = null

    private var serviceBusQueues: Output<List<RoutingServiceBusQueueEndpointPropertiesArgs>>? = null

    private var serviceBusTopics: Output<List<RoutingServiceBusTopicEndpointPropertiesArgs>>? = null

    private var storageContainers: Output<List<RoutingStorageContainerPropertiesArgs>>? = null

    /**
     * @param value The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("frlfvnsducxcewhd")
    public suspend fun cosmosDBSqlCollections(`value`: Output<List<RoutingCosmosDBSqlApiPropertiesArgs>>) {
        this.cosmosDBSqlCollections = value
    }

    @JvmName("figwlfywbbsvjlrv")
    public suspend fun cosmosDBSqlCollections(vararg values: Output<RoutingCosmosDBSqlApiPropertiesArgs>) {
        this.cosmosDBSqlCollections = Output.all(values.asList())
    }

    /**
     * @param values The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("kfeejcprvpukedwd")
    public suspend fun cosmosDBSqlCollections(values: List<Output<RoutingCosmosDBSqlApiPropertiesArgs>>) {
        this.cosmosDBSqlCollections = Output.all(values)
    }

    /**
     * @param value The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("kjlpfsvkjygtoslt")
    public suspend fun eventHubs(`value`: Output<List<RoutingEventHubPropertiesArgs>>) {
        this.eventHubs = value
    }

    @JvmName("raijllyiwuwgytre")
    public suspend fun eventHubs(vararg values: Output<RoutingEventHubPropertiesArgs>) {
        this.eventHubs = Output.all(values.asList())
    }

    /**
     * @param values The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("qxhheaucvndspyvo")
    public suspend fun eventHubs(values: List<Output<RoutingEventHubPropertiesArgs>>) {
        this.eventHubs = Output.all(values)
    }

    /**
     * @param value The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("evxagqlejadlnvxr")
    public suspend fun serviceBusQueues(`value`: Output<List<RoutingServiceBusQueueEndpointPropertiesArgs>>) {
        this.serviceBusQueues = value
    }

    @JvmName("ssauqvtkoalprjxv")
    public suspend fun serviceBusQueues(vararg values: Output<RoutingServiceBusQueueEndpointPropertiesArgs>) {
        this.serviceBusQueues = Output.all(values.asList())
    }

    /**
     * @param values The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("lhwbumqmssfkvute")
    public suspend fun serviceBusQueues(values: List<Output<RoutingServiceBusQueueEndpointPropertiesArgs>>) {
        this.serviceBusQueues = Output.all(values)
    }

    /**
     * @param value The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("vljuskotfpkplqnn")
    public suspend fun serviceBusTopics(`value`: Output<List<RoutingServiceBusTopicEndpointPropertiesArgs>>) {
        this.serviceBusTopics = value
    }

    @JvmName("caurlwxlxtamarlp")
    public suspend fun serviceBusTopics(vararg values: Output<RoutingServiceBusTopicEndpointPropertiesArgs>) {
        this.serviceBusTopics = Output.all(values.asList())
    }

    /**
     * @param values The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("xtgmccxhgcuuuoyc")
    public suspend fun serviceBusTopics(values: List<Output<RoutingServiceBusTopicEndpointPropertiesArgs>>) {
        this.serviceBusTopics = Output.all(values)
    }

    /**
     * @param value The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("yvmkfyxycrxrkakm")
    public suspend fun storageContainers(`value`: Output<List<RoutingStorageContainerPropertiesArgs>>) {
        this.storageContainers = value
    }

    @JvmName("djnoialeybkoklbe")
    public suspend fun storageContainers(vararg values: Output<RoutingStorageContainerPropertiesArgs>) {
        this.storageContainers = Output.all(values.asList())
    }

    /**
     * @param values The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("vegbsddxopkikidn")
    public suspend fun storageContainers(values: List<Output<RoutingStorageContainerPropertiesArgs>>) {
        this.storageContainers = Output.all(values)
    }

    /**
     * @param value The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("utdxuckudcosoroy")
    public suspend fun cosmosDBSqlCollections(`value`: List<RoutingCosmosDBSqlApiPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cosmosDBSqlCollections = mapped
    }

    /**
     * @param argument The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("oqvbtycgrwjobchg")
    public suspend fun cosmosDBSqlCollections(argument: List<suspend RoutingCosmosDBSqlApiPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingCosmosDBSqlApiPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cosmosDBSqlCollections = mapped
    }

    /**
     * @param argument The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("rgyfdgbbrgplswxi")
    public suspend fun cosmosDBSqlCollections(vararg argument: suspend RoutingCosmosDBSqlApiPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RoutingCosmosDBSqlApiPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cosmosDBSqlCollections = mapped
    }

    /**
     * @param argument The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("deyqwvigdxnwuguy")
    public suspend fun cosmosDBSqlCollections(argument: suspend RoutingCosmosDBSqlApiPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingCosmosDBSqlApiPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cosmosDBSqlCollections = mapped
    }

    /**
     * @param values The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("rteulgcpwtmumiif")
    public suspend fun cosmosDBSqlCollections(vararg values: RoutingCosmosDBSqlApiPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cosmosDBSqlCollections = mapped
    }

    /**
     * @param value The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("irrcfhpuyfeoxnkt")
    public suspend fun eventHubs(`value`: List<RoutingEventHubPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubs = mapped
    }

    /**
     * @param argument The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("caodeqqaqbakdkhj")
    public suspend fun eventHubs(argument: List<suspend RoutingEventHubPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingEventHubPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubs = mapped
    }

    /**
     * @param argument The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("xdrbcefrjcdiauwv")
    public suspend fun eventHubs(vararg argument: suspend RoutingEventHubPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RoutingEventHubPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubs = mapped
    }

    /**
     * @param argument The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("tcjfpxdrclyvfsyr")
    public suspend fun eventHubs(argument: suspend RoutingEventHubPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingEventHubPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.eventHubs = mapped
    }

    /**
     * @param values The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("ighovnvouvcqfjpa")
    public suspend fun eventHubs(vararg values: RoutingEventHubPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubs = mapped
    }

    /**
     * @param value The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("wrsjkldqojuahacg")
    public suspend fun serviceBusQueues(`value`: List<RoutingServiceBusQueueEndpointPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusQueues = mapped
    }

    /**
     * @param argument The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("eyvoxsxgpwsjsqpf")
    public suspend fun serviceBusQueues(argument: List<suspend RoutingServiceBusQueueEndpointPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingServiceBusQueueEndpointPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBusQueues = mapped
    }

    /**
     * @param argument The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("mvocugyvmthoymwj")
    public suspend fun serviceBusQueues(vararg argument: suspend RoutingServiceBusQueueEndpointPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RoutingServiceBusQueueEndpointPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBusQueues = mapped
    }

    /**
     * @param argument The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("iufhksktaavmendx")
    public suspend fun serviceBusQueues(argument: suspend RoutingServiceBusQueueEndpointPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingServiceBusQueueEndpointPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceBusQueues = mapped
    }

    /**
     * @param values The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("lqbcxmbuybhgfdsp")
    public suspend fun serviceBusQueues(vararg values: RoutingServiceBusQueueEndpointPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceBusQueues = mapped
    }

    /**
     * @param value The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("ecmrtddmsafvictn")
    public suspend fun serviceBusTopics(`value`: List<RoutingServiceBusTopicEndpointPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusTopics = mapped
    }

    /**
     * @param argument The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("dgakprojytntivmi")
    public suspend fun serviceBusTopics(argument: List<suspend RoutingServiceBusTopicEndpointPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingServiceBusTopicEndpointPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBusTopics = mapped
    }

    /**
     * @param argument The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("roevrugebbcsawva")
    public suspend fun serviceBusTopics(vararg argument: suspend RoutingServiceBusTopicEndpointPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RoutingServiceBusTopicEndpointPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBusTopics = mapped
    }

    /**
     * @param argument The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("lrhhtvbmkgsqoccp")
    public suspend fun serviceBusTopics(argument: suspend RoutingServiceBusTopicEndpointPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingServiceBusTopicEndpointPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceBusTopics = mapped
    }

    /**
     * @param values The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("qtgwallngixxhdtd")
    public suspend fun serviceBusTopics(vararg values: RoutingServiceBusTopicEndpointPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceBusTopics = mapped
    }

    /**
     * @param value The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("yksndeywuiuluwwc")
    public suspend fun storageContainers(`value`: List<RoutingStorageContainerPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainers = mapped
    }

    /**
     * @param argument The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("ekxxpvsdkdqpteko")
    public suspend fun storageContainers(argument: List<suspend RoutingStorageContainerPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingStorageContainerPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.storageContainers = mapped
    }

    /**
     * @param argument The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("rrspoxolkcfaaeyy")
    public suspend fun storageContainers(vararg argument: suspend RoutingStorageContainerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RoutingStorageContainerPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.storageContainers = mapped
    }

    /**
     * @param argument The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("wenequagnkqcqoqn")
    public suspend fun storageContainers(argument: suspend RoutingStorageContainerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingStorageContainerPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.storageContainers = mapped
    }

    /**
     * @param values The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("ylvbglhxihkukdnq")
    public suspend fun storageContainers(vararg values: RoutingStorageContainerPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageContainers = mapped
    }

    internal fun build(): RoutingEndpointsArgs = RoutingEndpointsArgs(
        cosmosDBSqlCollections = cosmosDBSqlCollections,
        eventHubs = eventHubs,
        serviceBusQueues = serviceBusQueues,
        serviceBusTopics = serviceBusTopics,
        storageContainers = storageContainers,
    )
}
