@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The description of an X509 CA Certificate.
 * @property certificate base-64 representation of X509 certificate .cer file or just .pem file content.
 * @property created The certificate's creation date and time.
 * @property expiry The certificate's expiration date and time.
 * @property isVerified Determines whether certificate has been verified.
 * @property subject The certificate's subject name.
 * @property thumbprint The certificate's thumbprint.
 * @property updated The certificate's last update date and time.
 */
public data class CertificatePropertiesResponse(
    public val certificate: String? = null,
    public val created: String,
    public val expiry: String,
    public val isVerified: Boolean? = null,
    public val subject: String,
    public val thumbprint: String,
    public val updated: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.CertificatePropertiesResponse): CertificatePropertiesResponse = CertificatePropertiesResponse(
            certificate = javaType.certificate().map({ args0 -> args0 }).orElse(null),
            created = javaType.created(),
            expiry = javaType.expiry(),
            isVerified = javaType.isVerified().map({ args0 -> args0 }).orElse(null),
            subject = javaType.subject(),
            thumbprint = javaType.thumbprint(),
            updated = javaType.updated(),
        )
    }
}
