@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The encryption properties for the IoT hub.
 * @property keySource The source of the key.
 * @property keyVaultProperties The properties of the KeyVault key.
 */
public data class EncryptionPropertiesDescriptionResponse(
    public val keySource: String? = null,
    public val keyVaultProperties: List<KeyVaultKeyPropertiesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.EncryptionPropertiesDescriptionResponse): EncryptionPropertiesDescriptionResponse = EncryptionPropertiesDescriptionResponse(
            keySource = javaType.keySource().map({ args0 -> args0 }).orElse(null),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.KeyVaultKeyPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
