@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of an enrichment that your IoT hub applies to messages delivered to endpoints.
 * @property endpointNames The list of endpoints for which the enrichment is applied to the message.
 * @property key The key or name for the enrichment property.
 * @property value The value for the enrichment property.
 */
public data class EnrichmentPropertiesResponse(
    public val endpointNames: List<String>,
    public val key: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.EnrichmentPropertiesResponse): EnrichmentPropertiesResponse = EnrichmentPropertiesResponse(
            endpointNames = javaType.endpointNames().map({ args0 -> args0 }),
            key = javaType.key(),
            `value` = javaType.`value`(),
        )
    }
}
