@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.
 * @property endpoint The Event Hub-compatible endpoint.
 * @property partitionCount The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
 * @property partitionIds The partition ids in the Event Hub-compatible endpoint.
 * @property path The Event Hub-compatible name.
 * @property retentionTimeInDays The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
 */
public data class EventHubPropertiesResponse(
    public val endpoint: String,
    public val partitionCount: Int? = null,
    public val partitionIds: List<String>,
    public val path: String,
    public val retentionTimeInDays: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.EventHubPropertiesResponse): EventHubPropertiesResponse = EventHubPropertiesResponse(
            endpoint = javaType.endpoint(),
            partitionCount = javaType.partitionCount().map({ args0 -> args0 }).orElse(null),
            partitionIds = javaType.partitionIds().map({ args0 -> args0 }),
            path = javaType.path(),
            retentionTimeInDays = javaType.retentionTimeInDays().map({ args0 -> args0 }).orElse(null),
        )
    }
}
