@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of the fallback route. IoT Hub uses these properties when it routes messages to the fallback endpoint.
 * @property condition The condition which is evaluated in order to apply the fallback route. If the condition is not provided it will evaluate to true by default. For grammar, See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
 * @property endpointNames The list of endpoints to which the messages that satisfy the condition are routed to. Currently only 1 endpoint is allowed.
 * @property isEnabled Used to specify whether the fallback route is enabled.
 * @property name The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
 * @property source The source to which the routing rule is to be applied to. For example, DeviceMessages
 */
public data class FallbackRoutePropertiesResponse(
    public val condition: String? = null,
    public val endpointNames: List<String>,
    public val isEnabled: Boolean,
    public val name: String? = null,
    public val source: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.FallbackRoutePropertiesResponse): FallbackRoutePropertiesResponse = FallbackRoutePropertiesResponse(
            condition = javaType.condition().map({ args0 -> args0 }).orElse(null),
            endpointNames = javaType.endpointNames().map({ args0 -> args0 }),
            isEnabled = javaType.isEnabled(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            source = javaType.source(),
        )
    }
}
