@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * List of possible provisioning service SKUs.
 * @property capacity The number of units to provision
 * @property name Sku name.
 * @property tier Pricing tier name of the provisioning service.
 */
public data class IotDpsSkuInfoResponse(
    public val capacity: Double? = null,
    public val name: String? = null,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.IotDpsSkuInfoResponse): IotDpsSkuInfoResponse = IotDpsSkuInfoResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier(),
        )
    }
}
