@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Description of the IoT hub.
 * @property allocationWeight weight to apply for a given iot h.
 * @property applyAllocationPolicy flag for applying allocationPolicy or not for a given iot hub.
 * @property connectionString Connection string of the IoT hub.
 * @property location ARM region of the IoT hub.
 * @property name Host name of the IoT hub.
 */
public data class IotHubDefinitionDescriptionResponse(
    public val allocationWeight: Int? = null,
    public val applyAllocationPolicy: Boolean? = null,
    public val connectionString: String,
    public val location: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.IotHubDefinitionDescriptionResponse): IotHubDefinitionDescriptionResponse = IotHubDefinitionDescriptionResponse(
            allocationWeight = javaType.allocationWeight().map({ args0 -> args0 }).orElse(null),
            applyAllocationPolicy = javaType.applyAllocationPolicy().map({ args0 -> args0 }).orElse(null),
            connectionString = javaType.connectionString(),
            location = javaType.location(),
            name = javaType.name(),
        )
    }
}
