@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Public representation of one of the locations where a resource is provisioned.
 * @property location The name of the Azure region
 * @property role The role of the region, can be either primary or secondary. The primary region is where the IoT hub is currently provisioned. The secondary region is the Azure disaster recovery (DR) paired region and also the region where the IoT hub can failover to.
 */
public data class IotHubLocationDescriptionResponse(
    public val location: String? = null,
    public val role: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.IotHubLocationDescriptionResponse): IotHubLocationDescriptionResponse = IotHubLocationDescriptionResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
        )
    }
}
