@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The device streams properties of iothub.
 * @property streamingEndpoints List of Device Streams Endpoints.
 */
public data class IotHubPropertiesResponseDeviceStreams(
    public val streamingEndpoints: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.IotHubPropertiesResponseDeviceStreams): IotHubPropertiesResponseDeviceStreams = IotHubPropertiesResponseDeviceStreams(
            streamingEndpoints = javaType.streamingEndpoints().map({ args0 -> args0 }),
        )
    }
}
