@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Information about the SKU of the IoT hub.
 * @property capacity The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
 * @property name The name of the SKU.
 * @property tier The billing tier for the IoT hub.
 */
public data class IotHubSkuInfoResponse(
    public val capacity: Double? = null,
    public val name: String,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.IotHubSkuInfoResponse): IotHubSkuInfoResponse = IotHubSkuInfoResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tier = javaType.tier(),
        )
    }
}
