@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The IP filter rules for the IoT hub.
 * @property action The desired action for requests captured by this rule.
 * @property filterName The name of the IP filter rule.
 * @property ipMask A string that contains the IP address range in CIDR notation for the rule.
 */
public data class IpFilterRuleResponse(
    public val action: String,
    public val filterName: String,
    public val ipMask: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.IpFilterRuleResponse): IpFilterRuleResponse = IpFilterRuleResponse(
            action = javaType.action(),
            filterName = javaType.filterName(),
            ipMask = javaType.ipMask(),
        )
    }
}
