@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the KeyVault key.
 * @property identity Managed identity properties of KeyVault Key.
 * @property keyIdentifier The identifier of the key.
 */
public data class KeyVaultKeyPropertiesResponse(
    public val identity: ManagedIdentityResponse? = null,
    public val keyIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.KeyVaultKeyPropertiesResponse): KeyVaultKeyPropertiesResponse = KeyVaultKeyPropertiesResponse(
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyIdentifier = javaType.keyIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
