@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description of the shared access key.
 * @property keyName Name of the key.
 * @property primaryKey Primary SAS key value.
 * @property rights Rights that this key has.
 * @property secondaryKey Secondary SAS key value.
 */
public data class ListIotDpsResourceKeysForKeyNameResult(
    public val keyName: String,
    public val primaryKey: String? = null,
    public val rights: String,
    public val secondaryKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.ListIotDpsResourceKeysForKeyNameResult): ListIotDpsResourceKeysForKeyNameResult = ListIotDpsResourceKeysForKeyNameResult(
            keyName = javaType.keyName(),
            primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
            rights = javaType.rights(),
            secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
