@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the Managed identity.
 * @property userAssignedIdentity The user assigned identity.
 */
public data class ManagedIdentityResponse(
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.ManagedIdentityResponse): ManagedIdentityResponse = ManagedIdentityResponse(
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
