@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The properties of the messaging endpoints used by this IoT hub.
 * @property lockDurationAsIso8601 The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
 * @property maxDeliveryCount The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
 * @property ttlAsIso8601 The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
 */
public data class MessagingEndpointPropertiesResponse(
    public val lockDurationAsIso8601: String? = null,
    public val maxDeliveryCount: Int? = null,
    public val ttlAsIso8601: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.MessagingEndpointPropertiesResponse): MessagingEndpointPropertiesResponse = MessagingEndpointPropertiesResponse(
            lockDurationAsIso8601 = javaType.lockDurationAsIso8601().map({ args0 -> args0 }).orElse(null),
            maxDeliveryCount = javaType.maxDeliveryCount().map({ args0 -> args0 }).orElse(null),
            ttlAsIso8601 = javaType.ttlAsIso8601().map({ args0 -> args0 }).orElse(null),
        )
    }
}
