@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP Rule to be applied as part of Network Rule Set
 * @property action IP Filter Action
 * @property filterName Name of the IP filter rule.
 * @property ipMask A string that contains the IP address range in CIDR notation for the rule.
 */
public data class NetworkRuleSetIpRuleResponse(
    public val action: String? = null,
    public val filterName: String,
    public val ipMask: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.NetworkRuleSetIpRuleResponse): NetworkRuleSetIpRuleResponse = NetworkRuleSetIpRuleResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            filterName = javaType.filterName(),
            ipMask = javaType.ipMask(),
        )
    }
}
