@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network Rule Set Properties of IotHub
 * @property applyToBuiltInEventHubEndpoint If True, then Network Rule Set is also applied to BuiltIn EventHub EndPoint of IotHub
 * @property defaultAction Default Action for Network Rule Set
 * @property ipRules List of IP Rules
 */
public data class NetworkRuleSetPropertiesResponse(
    public val applyToBuiltInEventHubEndpoint: Boolean,
    public val defaultAction: String? = null,
    public val ipRules: List<NetworkRuleSetIpRuleResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.NetworkRuleSetPropertiesResponse): NetworkRuleSetPropertiesResponse = NetworkRuleSetPropertiesResponse(
            applyToBuiltInEventHubEndpoint = javaType.applyToBuiltInEventHubEndpoint(),
            defaultAction = javaType.defaultAction().map({ args0 -> args0 }).orElse(null),
            ipRules = javaType.ipRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.NetworkRuleSetIpRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
