@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * This property store root certificate related information
 * @property enableRootCertificateV2 This property when set to true, hub will use G2 cert; while it's set to false, hub uses Baltimore Cert.
 * @property lastUpdatedTimeUtc the last update time to root certificate flag.
 */
public data class RootCertificatePropertiesResponse(
    public val enableRootCertificateV2: Boolean? = null,
    public val lastUpdatedTimeUtc: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.RootCertificatePropertiesResponse): RootCertificatePropertiesResponse = RootCertificatePropertiesResponse(
            enableRootCertificateV2 = javaType.enableRootCertificateV2().map({ args0 -> args0 }).orElse(null),
            lastUpdatedTimeUtc = javaType.lastUpdatedTimeUtc(),
        )
    }
}
