@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a routing rule that your IoT hub uses to route messages to endpoints.
 * @property condition The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
 * @property endpointNames The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
 * @property isEnabled Used to specify whether a route is enabled.
 * @property name The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
 * @property source The source that the routing rule is to be applied to, such as DeviceMessages.
 */
public data class RoutePropertiesResponse(
    public val condition: String? = null,
    public val endpointNames: List<String>,
    public val isEnabled: Boolean,
    public val name: String,
    public val source: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.RoutePropertiesResponse): RoutePropertiesResponse = RoutePropertiesResponse(
            condition = javaType.condition().map({ args0 -> args0 }).orElse(null),
            endpointNames = javaType.endpointNames().map({ args0 -> args0 }),
            isEnabled = javaType.isEnabled(),
            name = javaType.name(),
            source = javaType.source(),
        )
    }
}
