@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The properties related to a storage container endpoint.
 * @property authenticationType Method used to authenticate against the storage endpoint
 * @property batchFrequencyInSeconds Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
 * @property connectionString The connection string of the storage account.
 * @property containerName The name of storage container in the storage account.
 * @property encoding Encoding that is used to serialize messages to blobs. Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'.
 * @property endpointUri The url of the storage endpoint. It must include the protocol https://
 * @property fileNameFormat File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered.
 * @property id Id of the storage container endpoint
 * @property identity Managed identity properties of routing storage endpoint.
 * @property maxChunkSizeInBytes Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
 * @property name The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
 * @property resourceGroup The name of the resource group of the storage account.
 * @property subscriptionId The subscription identifier of the storage account.
 */
public data class RoutingStorageContainerPropertiesResponse(
    public val authenticationType: String? = null,
    public val batchFrequencyInSeconds: Int? = null,
    public val connectionString: String? = null,
    public val containerName: String,
    public val encoding: String? = null,
    public val endpointUri: String? = null,
    public val fileNameFormat: String? = null,
    public val id: String? = null,
    public val identity: ManagedIdentityResponse? = null,
    public val maxChunkSizeInBytes: Int? = null,
    public val name: String,
    public val resourceGroup: String? = null,
    public val subscriptionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.RoutingStorageContainerPropertiesResponse): RoutingStorageContainerPropertiesResponse = RoutingStorageContainerPropertiesResponse(
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            batchFrequencyInSeconds = javaType.batchFrequencyInSeconds().map({ args0 -> args0 }).orElse(null),
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
            containerName = javaType.containerName(),
            encoding = javaType.encoding().map({ args0 -> args0 }).orElse(null),
            endpointUri = javaType.endpointUri().map({ args0 -> args0 }).orElse(null),
            fileNameFormat = javaType.fileNameFormat().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            maxChunkSizeInBytes = javaType.maxChunkSizeInBytes().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
