@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The IP filter rules for a provisioning Service.
 * @property action The desired action for requests captured by this rule.
 * @property filterName The name of the IP filter rule.
 * @property ipMask A string that contains the IP address range in CIDR notation for the rule.
 * @property target Target for requests captured by this rule.
 */
public data class TargetIpFilterRuleResponse(
    public val action: String,
    public val filterName: String,
    public val ipMask: String,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.TargetIpFilterRuleResponse): TargetIpFilterRuleResponse = TargetIpFilterRuleResponse(
            action = javaType.action(),
            filterName = javaType.filterName(),
            ipMask = javaType.ipMask(),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
