@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin

import com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxyArgs.builder
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.RemotePrivateEndpointArgs
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.RemotePrivateEndpointArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Private endpoint connection proxy details.
 * Azure REST API version: 2023-07-01. Prior API version in Azure Native 1.x: 2020-03-01-preview.
 * ## Example Usage
 * ### PrivateEndpointConnectionProxyCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionProxy = new AzureNative.DeviceUpdate.PrivateEndpointConnectionProxy("privateEndpointConnectionProxy", new()
 *     {
 *         AccountName = "contoso",
 *         PrivateEndpointConnectionProxyId = "peexample01",
 *         RemotePrivateEndpoint = new AzureNative.DeviceUpdate.Inputs.RemotePrivateEndpointArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}",
 *             ImmutableResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}",
 *             ImmutableSubscriptionId = "00000000-0000-0000-0000-000000000000",
 *             Location = "westus2",
 *             ManualPrivateLinkServiceConnections = new[]
 *             {
 *                 new AzureNative.DeviceUpdate.Inputs.PrivateLinkServiceConnectionArgs
 *                 {
 *                     GroupIds = new[]
 *                     {
 *                         "DeviceUpdate",
 *                     },
 *                     Name = "{privateEndpointConnectionProxyId}",
 *                     RequestMessage = "Please approve my connection, thanks.",
 *                 },
 *             },
 *             PrivateLinkServiceProxies = new[]
 *             {
 *                 new AzureNative.DeviceUpdate.Inputs.PrivateLinkServiceProxyArgs
 *                 {
 *                     GroupConnectivityInformation = new() { },
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{privateEndpointConnectionProxyId}/privateLinkServiceProxies/{privateEndpointConnectionProxyId}",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceupdate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceupdate.NewPrivateEndpointConnectionProxy(ctx, "privateEndpointConnectionProxy", &deviceupdate.PrivateEndpointConnectionProxyArgs{
 * 			AccountName:                      pulumi.String("contoso"),
 * 			PrivateEndpointConnectionProxyId: pulumi.String("peexample01"),
 * 			RemotePrivateEndpoint: &deviceupdate.RemotePrivateEndpointArgs{
 * 				Id:                      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}"),
 * 				ImmutableResourceId:     pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}"),
 * 				ImmutableSubscriptionId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 				Location:                pulumi.String("westus2"),
 * 				ManualPrivateLinkServiceConnections: deviceupdate.PrivateLinkServiceConnectionArray{
 * 					&deviceupdate.PrivateLinkServiceConnectionArgs{
 * 						GroupIds: pulumi.StringArray{
 * 							pulumi.String("DeviceUpdate"),
 * 						},
 * 						Name:           pulumi.String("{privateEndpointConnectionProxyId}"),
 * 						RequestMessage: pulumi.String("Please approve my connection, thanks."),
 * 					},
 * 				},
 * 				PrivateLinkServiceProxies: deviceupdate.PrivateLinkServiceProxyArray{
 * 					&deviceupdate.PrivateLinkServiceProxyArgs{
 * 						GroupConnectivityInformation: deviceupdate.GroupConnectivityInformationArray{},
 * 						Id:                           pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{privateEndpointConnectionProxyId}/privateLinkServiceProxies/{privateEndpointConnectionProxyId}"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxy;
 * import com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxyArgs;
 * import com.pulumi.azurenative.deviceupdate.inputs.RemotePrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionProxy = new PrivateEndpointConnectionProxy("privateEndpointConnectionProxy", PrivateEndpointConnectionProxyArgs.builder()
 *             .accountName("contoso")
 *             .privateEndpointConnectionProxyId("peexample01")
 *             .remotePrivateEndpoint(RemotePrivateEndpointArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}")
 *                 .immutableResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{peName}")
 *                 .immutableSubscriptionId("00000000-0000-0000-0000-000000000000")
 *                 .location("westus2")
 *                 .manualPrivateLinkServiceConnections(PrivateLinkServiceConnectionArgs.builder()
 *                     .groupIds("DeviceUpdate")
 *                     .name("{privateEndpointConnectionProxyId}")
 *                     .requestMessage("Please approve my connection, thanks.")
 *                     .build())
 *                 .privateLinkServiceProxies(PrivateLinkServiceProxyArgs.builder()
 *                     .groupConnectivityInformation()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-rg/providers/Microsoft.Network/privateEndpoints/{privateEndpointConnectionProxyId}/privateLinkServiceProxies/{privateEndpointConnectionProxyId}")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceupdate:PrivateEndpointConnectionProxy peexample01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceUpdate/accounts/{accountName}/privateEndpointConnectionProxies/{privateEndpointConnectionProxyId}
 * ```
 * @property accountName Account name.
 * @property privateEndpointConnectionProxyId The ID of the private endpoint connection proxy object.
 * @property remotePrivateEndpoint Remote private endpoint details.
 * @property resourceGroupName The resource group name.
 * @property status Operation status.
 */
public data class PrivateEndpointConnectionProxyArgs(
    public val accountName: Output<String>? = null,
    public val privateEndpointConnectionProxyId: Output<String>? = null,
    public val remotePrivateEndpoint: Output<RemotePrivateEndpointArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxyArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxyArgs =
        com.pulumi.azurenative.deviceupdate.PrivateEndpointConnectionProxyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionProxyId(privateEndpointConnectionProxyId?.applyValue({ args0 -> args0 }))
            .remotePrivateEndpoint(
                remotePrivateEndpoint?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionProxyArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionProxyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var privateEndpointConnectionProxyId: Output<String>? = null

    private var remotePrivateEndpoint: Output<RemotePrivateEndpointArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Account name.
     */
    @JvmName("gbxdoiorujbossuc")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The ID of the private endpoint connection proxy object.
     */
    @JvmName("tcsjnnmdurkimylj")
    public suspend fun privateEndpointConnectionProxyId(`value`: Output<String>) {
        this.privateEndpointConnectionProxyId = value
    }

    /**
     * @param value Remote private endpoint details.
     */
    @JvmName("kccmlvpdyqlmgqun")
    public suspend fun remotePrivateEndpoint(`value`: Output<RemotePrivateEndpointArgs>) {
        this.remotePrivateEndpoint = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("pdeujqwsquqkdbvu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Operation status.
     */
    @JvmName("oknsolacauvqwbra")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Account name.
     */
    @JvmName("dsublxdtflvijxuc")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The ID of the private endpoint connection proxy object.
     */
    @JvmName("kgxeymjcdbkfipyc")
    public suspend fun privateEndpointConnectionProxyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionProxyId = mapped
    }

    /**
     * @param value Remote private endpoint details.
     */
    @JvmName("tgemrtowychiwxje")
    public suspend fun remotePrivateEndpoint(`value`: RemotePrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remotePrivateEndpoint = mapped
    }

    /**
     * @param argument Remote private endpoint details.
     */
    @JvmName("yqklftomqdowpfdt")
    public suspend fun remotePrivateEndpoint(argument: suspend RemotePrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = RemotePrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remotePrivateEndpoint = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("axbhmqflihhhhjwj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Operation status.
     */
    @JvmName("nyfofktwqjpjfamu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateEndpointConnectionProxyArgs = PrivateEndpointConnectionProxyArgs(
        accountName = accountName,
        privateEndpointConnectionProxyId = privateEndpointConnectionProxyId,
        remotePrivateEndpoint = remotePrivateEndpoint,
        resourceGroupName = resourceGroupName,
        status = status,
    )
}
