@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.inputs

import com.pulumi.azurenative.deviceupdate.inputs.GetInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Account name.
 * @property instanceName Instance name.
 * @property resourceGroupName The resource group name.
 */
public data class GetInstancePlainArgs(
    public val accountName: String,
    public val instanceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.deviceupdate.inputs.GetInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceupdate.inputs.GetInstancePlainArgs =
        com.pulumi.azurenative.deviceupdate.inputs.GetInstancePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .instanceName(instanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancePlainArgs].
 */
@PulumiTagMarker
public class GetInstancePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var instanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Account name.
     */
    @JvmName("hjfdxhecvjjdtwfy")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Instance name.
     */
    @JvmName("plshwfmqmqwhpxji")
    public suspend fun instanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("jiyoxftwuafnhynh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInstancePlainArgs = GetInstancePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        instanceName = instanceName ?: throw PulumiNullFieldException("instanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
