@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.inputs

import com.pulumi.azurenative.deviceupdate.inputs.IotHubSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Device Update account integration with IoT Hub settings.
 * @property resourceId IoTHub resource ID
 */
public data class IotHubSettingsArgs(
    public val resourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.deviceupdate.inputs.IotHubSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceupdate.inputs.IotHubSettingsArgs =
        com.pulumi.azurenative.deviceupdate.inputs.IotHubSettingsArgs.builder()
            .resourceId(resourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IotHubSettingsArgs].
 */
@PulumiTagMarker
public class IotHubSettingsArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    /**
     * @param value IoTHub resource ID
     */
    @JvmName("lmjomcrvlldydaxr")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value IoTHub resource ID
     */
    @JvmName("rfeuqepnyupvvwww")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): IotHubSettingsArgs = IotHubSettingsArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
