@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Customer-initiated diagnostic log collection storage properties
 * @property authenticationType Authentication Type
 * @property connectionString ConnectionString of the diagnostic storage account
 * @property resourceId ResourceId of the diagnostic storage account
 */
public data class DiagnosticStoragePropertiesResponse(
    public val authenticationType: String,
    public val connectionString: String? = null,
    public val resourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceupdate.outputs.DiagnosticStoragePropertiesResponse): DiagnosticStoragePropertiesResponse = DiagnosticStoragePropertiesResponse(
            authenticationType = javaType.authenticationType(),
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId(),
        )
    }
}
