@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Private endpoint connection proxy details.
 * @property eTag ETag from NRP.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the private endpoint connection proxy resource.
 * @property remotePrivateEndpoint Remote private endpoint details.
 * @property status Operation status.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPrivateEndpointConnectionProxyResult(
    public val eTag: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val remotePrivateEndpoint: RemotePrivateEndpointResponse? = null,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceupdate.outputs.GetPrivateEndpointConnectionProxyResult): GetPrivateEndpointConnectionProxyResult = GetPrivateEndpointConnectionProxyResult(
            eTag = javaType.eTag(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            remotePrivateEndpoint = javaType.remotePrivateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceupdate.kotlin.outputs.RemotePrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.deviceupdate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
