@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Device Update account integration with IoT Hub settings.
 * @property resourceId IoTHub resource ID
 */
public data class IotHubSettingsResponse(
    public val resourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceupdate.outputs.IotHubSettingsResponse): IotHubSettingsResponse = IotHubSettingsResponse(
            resourceId = javaType.resourceId(),
        )
    }
}
