@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Private link service connection details.
 * @property groupIds List of group IDs.
 * @property name Private link service connection name.
 * @property requestMessage Request message.
 */
public data class PrivateLinkServiceConnectionResponse(
    public val groupIds: List<String>? = null,
    public val name: String? = null,
    public val requestMessage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceupdate.outputs.PrivateLinkServiceConnectionResponse): PrivateLinkServiceConnectionResponse = PrivateLinkServiceConnectionResponse(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            requestMessage = javaType.requestMessage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
