@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Remote private endpoint details.
 * @property connectionDetails List of connection details.
 * @property id Remote endpoint resource ID.
 * @property immutableResourceId Original resource ID needed by Microsoft.Network.
 * @property immutableSubscriptionId Original subscription ID needed by Microsoft.Network.
 * @property location ARM location of the remote private endpoint.
 * @property manualPrivateLinkServiceConnections List of private link service connections that need manual approval.
 * @property privateLinkServiceConnections List of automatically approved private link service connections.
 * @property privateLinkServiceProxies List of private link service proxies.
 * @property vnetTrafficTag Virtual network traffic tag.
 */
public data class RemotePrivateEndpointResponse(
    public val connectionDetails: List<ConnectionDetailsResponse>? = null,
    public val id: String? = null,
    public val immutableResourceId: String? = null,
    public val immutableSubscriptionId: String? = null,
    public val location: String? = null,
    public val manualPrivateLinkServiceConnections: List<PrivateLinkServiceConnectionResponse>? =
        null,
    public val privateLinkServiceConnections: List<PrivateLinkServiceConnectionResponse>? = null,
    public val privateLinkServiceProxies: List<PrivateLinkServiceProxyResponse>? = null,
    public val vnetTrafficTag: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceupdate.outputs.RemotePrivateEndpointResponse): RemotePrivateEndpointResponse = RemotePrivateEndpointResponse(
            connectionDetails = javaType.connectionDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceupdate.kotlin.outputs.ConnectionDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            immutableResourceId = javaType.immutableResourceId().map({ args0 -> args0 }).orElse(null),
            immutableSubscriptionId = javaType.immutableSubscriptionId().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            manualPrivateLinkServiceConnections = javaType.manualPrivateLinkServiceConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceupdate.kotlin.outputs.PrivateLinkServiceConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            privateLinkServiceConnections = javaType.privateLinkServiceConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceupdate.kotlin.outputs.PrivateLinkServiceConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            privateLinkServiceProxies = javaType.privateLinkServiceProxies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceupdate.kotlin.outputs.PrivateLinkServiceProxyResponse.Companion.toKotlin(args0)
                })
            }),
            vnetTrafficTag = javaType.vnetTrafficTag().map({ args0 -> args0 }).orElse(null),
        )
    }
}
