@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs

import com.pulumi.azurenative.devopsinfrastructure.inputs.DevOpsAzureSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Azure SKU of the machines in the pool.
 * @property name The Azure SKU name of the machines in the pool.
 * @property tier The Azure SKU tier of the machines in the pool.
 */
public data class DevOpsAzureSkuArgs(
    public val name: Output<String>,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.inputs.DevOpsAzureSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.devopsinfrastructure.inputs.DevOpsAzureSkuArgs =
        com.pulumi.azurenative.devopsinfrastructure.inputs.DevOpsAzureSkuArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevOpsAzureSkuArgs].
 */
@PulumiTagMarker
public class DevOpsAzureSkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value The Azure SKU name of the machines in the pool.
     */
    @JvmName("gvuuhnqfjnsgflxf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Azure SKU tier of the machines in the pool.
     */
    @JvmName("louxkmqcxwsahekd")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The Azure SKU name of the machines in the pool.
     */
    @JvmName("tnauydmsyidrjogj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Azure SKU tier of the machines in the pool.
     */
    @JvmName("coyhnocoqbomrpvo")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): DevOpsAzureSkuArgs = DevOpsAzureSkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
