@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs

import com.pulumi.azurenative.devopsinfrastructure.inputs.GetPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property poolName Name of the pool. It needs to be globally unique.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPoolPlainArgs(
    public val poolName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.inputs.GetPoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devopsinfrastructure.inputs.GetPoolPlainArgs =
        com.pulumi.azurenative.devopsinfrastructure.inputs.GetPoolPlainArgs.builder()
            .poolName(poolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPoolPlainArgs].
 */
@PulumiTagMarker
public class GetPoolPlainArgsBuilder internal constructor() {
    private var poolName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the pool. It needs to be globally unique.
     */
    @JvmName("oslahkhicoufevuj")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wyynqhrxmapxvwar")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPoolPlainArgs = GetPoolPlainArgs(
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
