@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs

import com.pulumi.azurenative.devopsinfrastructure.inputs.OrganizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines an Azure DevOps organization.
 * @property parallelism How many machines can be created at maximum in this organization out of the maximumConcurrency of the pool.
 * @property projects Optional list of projects in which the pool should be created.
 * @property url The Azure DevOps organization URL in which the pool should be created.
 */
public data class OrganizationArgs(
    public val parallelism: Output<Int>? = null,
    public val projects: Output<List<String>>? = null,
    public val url: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.inputs.OrganizationArgs> {
    override fun toJava(): com.pulumi.azurenative.devopsinfrastructure.inputs.OrganizationArgs =
        com.pulumi.azurenative.devopsinfrastructure.inputs.OrganizationArgs.builder()
            .parallelism(parallelism?.applyValue({ args0 -> args0 }))
            .projects(projects?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationArgs].
 */
@PulumiTagMarker
public class OrganizationArgsBuilder internal constructor() {
    private var parallelism: Output<Int>? = null

    private var projects: Output<List<String>>? = null

    private var url: Output<String>? = null

    /**
     * @param value How many machines can be created at maximum in this organization out of the maximumConcurrency of the pool.
     */
    @JvmName("hhifskyggwdxxhdv")
    public suspend fun parallelism(`value`: Output<Int>) {
        this.parallelism = value
    }

    /**
     * @param value Optional list of projects in which the pool should be created.
     */
    @JvmName("krpiwkuumogtwijo")
    public suspend fun projects(`value`: Output<List<String>>) {
        this.projects = value
    }

    @JvmName("bupysamindhgulhs")
    public suspend fun projects(vararg values: Output<String>) {
        this.projects = Output.all(values.asList())
    }

    /**
     * @param values Optional list of projects in which the pool should be created.
     */
    @JvmName("iobmthcptovkcoho")
    public suspend fun projects(values: List<Output<String>>) {
        this.projects = Output.all(values)
    }

    /**
     * @param value The Azure DevOps organization URL in which the pool should be created.
     */
    @JvmName("etkjnmfqrcmeipcn")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value How many machines can be created at maximum in this organization out of the maximumConcurrency of the pool.
     */
    @JvmName("jsrojxolggeboyxe")
    public suspend fun parallelism(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelism = mapped
    }

    /**
     * @param value Optional list of projects in which the pool should be created.
     */
    @JvmName("souaclgmbxotpwyh")
    public suspend fun projects(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projects = mapped
    }

    /**
     * @param values Optional list of projects in which the pool should be created.
     */
    @JvmName("eanyjwfyqvkymome")
    public suspend fun projects(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projects = mapped
    }

    /**
     * @param value The Azure DevOps organization URL in which the pool should be created.
     */
    @JvmName("rbdvrngwsxrtvxqw")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): OrganizationArgs = OrganizationArgs(
        parallelism = parallelism,
        projects = projects,
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
