@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs

import com.pulumi.azurenative.devopsinfrastructure.inputs.OsProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The OS profile of the machines in the pool.
 * @property secretsManagementSettings The secret management settings of the machines in the pool.
 */
public data class OsProfileArgs(
    public val secretsManagementSettings: Output<SecretsManagementSettingsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.inputs.OsProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.devopsinfrastructure.inputs.OsProfileArgs =
        com.pulumi.azurenative.devopsinfrastructure.inputs.OsProfileArgs.builder()
            .secretsManagementSettings(
                secretsManagementSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OsProfileArgs].
 */
@PulumiTagMarker
public class OsProfileArgsBuilder internal constructor() {
    private var secretsManagementSettings: Output<SecretsManagementSettingsArgs>? = null

    /**
     * @param value The secret management settings of the machines in the pool.
     */
    @JvmName("wyrjhardabalcbfc")
    public suspend fun secretsManagementSettings(`value`: Output<SecretsManagementSettingsArgs>) {
        this.secretsManagementSettings = value
    }

    /**
     * @param value The secret management settings of the machines in the pool.
     */
    @JvmName("vilqdsbvspmunrhi")
    public suspend fun secretsManagementSettings(`value`: SecretsManagementSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretsManagementSettings = mapped
    }

    /**
     * @param argument The secret management settings of the machines in the pool.
     */
    @JvmName("fjesahksgbybicwl")
    public suspend fun secretsManagementSettings(argument: suspend SecretsManagementSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SecretsManagementSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secretsManagementSettings = mapped
    }

    internal fun build(): OsProfileArgs = OsProfileArgs(
        secretsManagementSettings = secretsManagementSettings ?: throw
            PulumiNullFieldException("secretsManagementSettings"),
    )
}
