@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Concrete tracked resource types can be created by aliasing this type using a specific property type.
 * @property agentProfile Defines how the machine will be handled once it executed a job.
 * @property devCenterProjectResourceId The resource id of the DevCenter Project the pool belongs to.
 * @property fabricProfile Defines the type of fabric the agent will run on.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The managed service identities assigned to this resource.
 * @property location The geo-location where the resource lives
 * @property maximumConcurrency Defines how many resources can there be created at any given time.
 * @property name The name of the resource
 * @property organizationProfile Defines the organization in which the pool will be used.
 * @property provisioningState The status of the current operation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPoolResult(
    public val agentProfile: Either<StatefulResponse, StatelessAgentProfileResponse>,
    public val devCenterProjectResourceId: String,
    public val fabricProfile: VmssFabricProfileResponse,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String,
    public val maximumConcurrency: Int,
    public val name: String,
    public val organizationProfile: AzureDevOpsOrganizationProfileResponse,
    public val provisioningState: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.outputs.GetPoolResult): GetPoolResult = GetPoolResult(
            agentProfile = javaType.agentProfile().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.StatefulResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.StatelessAgentProfileResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            devCenterProjectResourceId = javaType.devCenterProjectResourceId(),
            fabricProfile = javaType.fabricProfile().let({ args0 ->
                com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.VmssFabricProfileResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            maximumConcurrency = javaType.maximumConcurrency(),
            name = javaType.name(),
            organizationProfile = javaType.organizationProfile().let({ args0 ->
                com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.AzureDevOpsOrganizationProfileResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
