@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The network profile of the machines in the pool.
 * @property subnetId The subnet id on which to put all machines created in the pool.
 */
public data class NetworkProfileResponse(
    public val subnetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.outputs.NetworkProfileResponse): NetworkProfileResponse = NetworkProfileResponse(
            subnetId = javaType.subnetId(),
        )
    }
}
