@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines an Azure DevOps organization.
 * @property parallelism How many machines can be created at maximum in this organization out of the maximumConcurrency of the pool.
 * @property projects Optional list of projects in which the pool should be created.
 * @property url The Azure DevOps organization URL in which the pool should be created.
 */
public data class OrganizationResponse(
    public val parallelism: Int? = null,
    public val projects: List<String>? = null,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.outputs.OrganizationResponse): OrganizationResponse = OrganizationResponse(
            parallelism = javaType.parallelism().map({ args0 -> args0 }).orElse(null),
            projects = javaType.projects().map({ args0 -> args0 }),
            url = javaType.url(),
        )
    }
}
