@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs

import kotlin.Suppress

/**
 * The OS profile of the machines in the pool.
 * @property secretsManagementSettings The secret management settings of the machines in the pool.
 */
public data class OsProfileResponse(
    public val secretsManagementSettings: SecretsManagementSettingsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.outputs.OsProfileResponse): OsProfileResponse = OsProfileResponse(
            secretsManagementSettings = javaType.secretsManagementSettings().let({ args0 ->
                com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.SecretsManagementSettingsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
