@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The secret management settings of the machines in the pool.
 * @property certificateStoreLocation Where to store certificates on the machine.
 * @property keyExportable Defines if the key of the certificates should be exportable.
 * @property observedCertificates The list of certificates to install on all machines in the pool.
 */
public data class SecretsManagementSettingsResponse(
    public val certificateStoreLocation: String? = null,
    public val keyExportable: Boolean,
    public val observedCertificates: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.outputs.SecretsManagementSettingsResponse): SecretsManagementSettingsResponse = SecretsManagementSettingsResponse(
            certificateStoreLocation = javaType.certificateStoreLocation().map({ args0 -> args0 }).orElse(null),
            keyExportable = javaType.keyExportable(),
            observedCertificates = javaType.observedCertificates().map({ args0 -> args0 }),
        )
    }
}
