@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Stateless profile meaning that the machines will be cleaned up after running a job.
 * @property kind Discriminator property for AgentProfile.
 * Expected value is 'Stateless'.
 * @property resourcePredictions Defines pool buffer.
 */
public data class StatelessAgentProfileResponse(
    public val kind: String,
    public val resourcePredictions: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.outputs.StatelessAgentProfileResponse): StatelessAgentProfileResponse = StatelessAgentProfileResponse(
            kind = javaType.kind(),
            resourcePredictions = javaType.resourcePredictions().map({ args0 -> args0 }).orElse(null),
        )
    }
}
