@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devspaces.kotlin

import com.pulumi.azurenative.devspaces.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.devspaces.kotlin.outputs.SkuResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Controller].
 */
@PulumiTagMarker
public class ControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ControllerArgs = ControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ControllerArgsBuilder.() -> Unit) {
        val builder = ControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Controller {
        val builtJavaResource = com.pulumi.azurenative.devspaces.Controller(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Controller(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2019-04-01. Prior API version in Azure Native 1.x: 2019-04-01.
 * ## Example Usage
 * ### ControllersCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var controller = new AzureNative.DevSpaces.Controller("controller", new()
 *     {
 *         Location = "eastus",
 *         Name = "myControllerResource",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.DevSpaces.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.DevSpaces.SkuName.S1,
 *             Tier = AzureNative.DevSpaces.SkuTier.Standard,
 *         },
 *         Tags = null,
 *         TargetContainerHostCredentialsBase64 = "QmFzZTY0IEVuY29kZWQgVmFsdWUK",
 *         TargetContainerHostResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myCluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devspaces/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devspaces.NewController(ctx, "controller", &devspaces.ControllerArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			Name:              pulumi.String("myControllerResource"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &devspaces.SkuArgs{
 * 				Name: pulumi.String(devspaces.SkuNameS1),
 * 				Tier: pulumi.String(devspaces.SkuTierStandard),
 * 			},
 * 			Tags:                                 nil,
 * 			TargetContainerHostCredentialsBase64: pulumi.String("QmFzZTY0IEVuY29kZWQgVmFsdWUK"),
 * 			TargetContainerHostResourceId:        pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myCluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devspaces.Controller;
 * import com.pulumi.azurenative.devspaces.ControllerArgs;
 * import com.pulumi.azurenative.devspaces.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var controller = new Controller("controller", ControllerArgs.builder()
 *             .location("eastus")
 *             .name("myControllerResource")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("S1")
 *                 .tier("Standard")
 *                 .build())
 *             .tags()
 *             .targetContainerHostCredentialsBase64("QmFzZTY0IEVuY29kZWQgVmFsdWUK")
 *             .targetContainerHostResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myCluster")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devspaces:Controller myControllerResource /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevSpaces/controllers/{name}
 * ```
 */
public class Controller internal constructor(
    override val javaResource: com.pulumi.azurenative.devspaces.Controller,
) : KotlinCustomResource(javaResource, ControllerMapper) {
    /**
     * DNS name for accessing DataPlane services
     */
    public val dataPlaneFqdn: Output<String>
        get() = javaResource.dataPlaneFqdn().applyValue({ args0 -> args0 })

    /**
     * DNS suffix for public endpoints running in the Azure Dev Spaces Controller.
     */
    public val hostSuffix: Output<String>
        get() = javaResource.hostSuffix().applyValue({ args0 -> args0 })

    /**
     * Region where the Azure resource is located.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the Azure Dev Spaces Controller.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Model representing SKU for Azure Dev Spaces Controller.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Tags for the Azure resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * DNS of the target container host's API server
     */
    public val targetContainerHostApiServerFqdn: Output<String>
        get() = javaResource.targetContainerHostApiServerFqdn().applyValue({ args0 -> args0 })

    /**
     * Resource ID of the target container host
     */
    public val targetContainerHostResourceId: Output<String>
        get() = javaResource.targetContainerHostResourceId().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ControllerMapper : ResourceMapper<Controller> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devspaces.Controller::class == javaResource::class

    override fun map(javaResource: Resource): Controller = Controller(
        javaResource as
            com.pulumi.azurenative.devspaces.Controller,
    )
}

/**
 * @see [Controller].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Controller].
 */
public suspend fun controller(name: String, block: suspend ControllerResourceBuilder.() -> Unit): Controller {
    val builder = ControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Controller].
 * @param name The _unique_ name of the resulting resource.
 */
public fun controller(name: String): Controller {
    val builder = ControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
