@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devspaces.kotlin

import com.pulumi.azurenative.devspaces.DevspacesFunctions.getControllerPlain
import com.pulumi.azurenative.devspaces.DevspacesFunctions.listControllerConnectionDetailsPlain
import com.pulumi.azurenative.devspaces.kotlin.inputs.GetControllerPlainArgs
import com.pulumi.azurenative.devspaces.kotlin.inputs.GetControllerPlainArgsBuilder
import com.pulumi.azurenative.devspaces.kotlin.inputs.ListControllerConnectionDetailsPlainArgs
import com.pulumi.azurenative.devspaces.kotlin.inputs.ListControllerConnectionDetailsPlainArgsBuilder
import com.pulumi.azurenative.devspaces.kotlin.outputs.GetControllerResult
import com.pulumi.azurenative.devspaces.kotlin.outputs.ListControllerConnectionDetailsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.devspaces.kotlin.outputs.GetControllerResult.Companion.toKotlin as getControllerResultToKotlin
import com.pulumi.azurenative.devspaces.kotlin.outputs.ListControllerConnectionDetailsResult.Companion.toKotlin as listControllerConnectionDetailsResultToKotlin

public object DevspacesFunctions {
    /**
     * Gets the properties for an Azure Dev Spaces Controller.
     * Azure REST API version: 2019-04-01.
     * @param argument null
     * @return null
     */
    public suspend fun getController(argument: GetControllerPlainArgs): GetControllerResult =
        getControllerResultToKotlin(getControllerPlain(argument.toJava()).await())

    /**
     * @see [getController].
     * @param name Name of the resource.
     * @param resourceGroupName Resource group to which the resource belongs.
     * @return null
     */
    public suspend fun getController(name: String, resourceGroupName: String): GetControllerResult {
        val argument = GetControllerPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getControllerResultToKotlin(getControllerPlain(argument.toJava()).await())
    }

    /**
     * @see [getController].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devspaces&#46;kotlin&#46;inputs&#46;GetControllerPlainArgs].
     * @return null
     */
    public suspend fun getController(argument: suspend GetControllerPlainArgsBuilder.() -> Unit): GetControllerResult {
        val builder = GetControllerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getControllerResultToKotlin(getControllerPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists connection details for the underlying container resources of an Azure Dev Spaces Controller.
     * Azure REST API version: 2019-04-01.
     * @param argument null
     * @return null
     */
    public suspend fun listControllerConnectionDetails(argument: ListControllerConnectionDetailsPlainArgs): ListControllerConnectionDetailsResult =
        listControllerConnectionDetailsResultToKotlin(listControllerConnectionDetailsPlain(argument.toJava()).await())

    /**
     * @see [listControllerConnectionDetails].
     * @param name Name of the resource.
     * @param resourceGroupName Resource group to which the resource belongs.
     * @param targetContainerHostResourceId Resource ID of the target container host mapped to the Azure Dev Spaces Controller.
     * @return null
     */
    public suspend fun listControllerConnectionDetails(
        name: String,
        resourceGroupName: String,
        targetContainerHostResourceId: String,
    ): ListControllerConnectionDetailsResult {
        val argument = ListControllerConnectionDetailsPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            targetContainerHostResourceId = targetContainerHostResourceId,
        )
        return listControllerConnectionDetailsResultToKotlin(listControllerConnectionDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [listControllerConnectionDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devspaces&#46;kotlin&#46;inputs&#46;ListControllerConnectionDetailsPlainArgs].
     * @return null
     */
    public suspend fun listControllerConnectionDetails(argument: suspend ListControllerConnectionDetailsPlainArgsBuilder.() -> Unit): ListControllerConnectionDetailsResult {
        val builder = ListControllerConnectionDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listControllerConnectionDetailsResultToKotlin(listControllerConnectionDetailsPlain(builtArgument.toJava()).await())
    }
}
