@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devspaces.kotlin.inputs

import com.pulumi.azurenative.devspaces.inputs.ListControllerConnectionDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the resource.
 * @property resourceGroupName Resource group to which the resource belongs.
 * @property targetContainerHostResourceId Resource ID of the target container host mapped to the Azure Dev Spaces Controller.
 */
public data class ListControllerConnectionDetailsPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val targetContainerHostResourceId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.devspaces.inputs.ListControllerConnectionDetailsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devspaces.inputs.ListControllerConnectionDetailsPlainArgs =
        com.pulumi.azurenative.devspaces.inputs.ListControllerConnectionDetailsPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .targetContainerHostResourceId(targetContainerHostResourceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListControllerConnectionDetailsPlainArgs].
 */
@PulumiTagMarker
public class ListControllerConnectionDetailsPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var targetContainerHostResourceId: String? = null

    /**
     * @param value Name of the resource.
     */
    @JvmName("ygkcckqumvinnhat")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Resource group to which the resource belongs.
     */
    @JvmName("iddvtbjqeotjwjrg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource ID of the target container host mapped to the Azure Dev Spaces Controller.
     */
    @JvmName("ekgeactllttchxuf")
    public suspend fun targetContainerHostResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetContainerHostResourceId = mapped
    }

    internal fun build(): ListControllerConnectionDetailsPlainArgs =
        ListControllerConnectionDetailsPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            targetContainerHostResourceId = targetContainerHostResourceId ?: throw
                PulumiNullFieldException("targetContainerHostResourceId"),
        )
}
